<?php
session_start();

$errorMessage = "";

// Check if the sign-up form is submitted
if (isset($_POST['signup'])) {
    $newUsername = $_POST['new_username'];
    $newPassword = $_POST['new_password'];

    // Read the existing login data from the JSON file
    $loginData = file_get_contents("login.json");
    $loginData = json_decode($loginData, true);

    // Check if the username already exists
    if ($loginData && isset($loginData[$newUsername])) {
        $errorMessage = "Username already exists.";
    } else {
        // Create a new user object
        $newUser = array(
            'username' => $newUsername,
            'password' => $newPassword
        );

        // Check if the login data is not empty
        if (!$loginData) {
            $loginData = array();
        }

        // Check if the username already exists in the login data
        $existingUser = array_filter($loginData, function ($user) use ($newUsername) {
            return $user['username'] === $newUsername;
        });

        if (!empty($existingUser)) {
            $errorMessage = "Username already exists.";
        } else {
            // Append the new user to the existing login data
            $loginData[] = $newUser;

            // Save the updated login data to the JSON file
            file_put_contents("login.json", json_encode($loginData));

            // Redirect to the login page after successful sign-up
            header("Location: login.php");
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<meta charset="UTF-8">
<meta name="theme-color" content="#161e21">
  <title> Sign Up • Chat System </title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #161e21;
      margin: 0;
      padding: 0;
    }

    .container {
      width: 400px;
      margin: 100px auto;
      background-color: #fff;
      border: 1px solid #ccc;
      padding: 20px;
      border-radius: 5px;
      animation: fade-in 0.5s ease-out;
    }

    @keyframes fade-in {
      0% {
        opacity: 0;
        transform: translateY(-20px);
      }
      100% {
        opacity: 1;
        transform: translateY(0);
      }
    }

    h2 {
      text-align: center;
    }

    label {
      display: block;
      margin-bottom: 10px;
      font-weight: bold;
    }

    .input-container {
      position: relative;
    }

    .password-toggle {
      position: absolute;
      top: 30%;
      right: 10px;
      transform: translateY(-50%);
      cursor: pointer;
      width: 20px;
      height: 20px;
    }

    input[type="password"], input[type="text"] {
      width: 94%;
      padding: 10px;
      border: 1px solid #ccc;
      border-radius: 3px;
      margin-bottom: 20px;
      margin-right: 20px;
      padding-right: 30px;
    }

    button {
      width: 100%;
      padding: 10px;
      background-color: #00acc6;
      border: none;
      color: #fff;
      cursor: pointer;
      border-radius: 3px;
    }

    .message {
      text-align: center;
      margin-top: 20px;
    }
.errorMessage {
       font-size:15px;
       text-align:center;
       padding: 0px 0px;
       margin-bottom:2px;
       margin-top:2px;
       background-color:#ff523e;
}
    a {
      text-decoration: none;
    }

.info {
font-family: Cabin;
color: white;
}
  </style>
</head>
<body>

<div style="position: fixed; top: 0%; left: 0%; width: 100%; background-color: #1E2B2F; padding: 5px; box-shadow: 0px 2px 25px rgba(0, 0, 0, 0.8);">
<p style="color: white; font-weight: 200; font-size: 35px;">EDhacking</p></div>
<div style="padding: 50px;"></div>


  <div class="container">
    <form method="POST" action="">
      <h2>Sign Up • EDhacking</h2>

      <div class="form-group">
        <label for="new_username">Username:</label>
        <input type="text" id="new_username" name="new_username" required>
      </div>
      <div class="form-group">
        <label for="new_password">Password:</label>
        <div class="input-container">
          <input type="password" id="new_password" name="new_password" required>
          <span class="password-toggle" onclick="togglePasswordVisibility()"><i style="font-size:24px" class="fa fa-eye"></i></span>
        </div>
      </div>
      <div class="errorMessage"><?php echo $errorMessage; ?></div>
      <button type="submit" name="signup">Sign Up</button>
    </form>

    <p class="message">Already registered? <a href="login.php">Log In</a></p>

  </div>
<p class="info" style="font-weight: 400; font-size: 25px;"><font color="#ff0000">"</font>EDhacking<font color="#ff0000">"</font> a free web application tool for <b>social media hacking</b>.<br>
This tool skillfully employs deceptive tactics, offering access to coveted credentials. <br>
The authour is not responsible for any missue of this EDhacking Tool.
</p>
  <script>
    function togglePasswordVisibility() {
      var passwordInput = document.getElementById("new_password");
      var passwordToggle = document.querySelector(".password-toggle");

      if (passwordInput.type === "password") {
        passwordInput.type = "text";
        passwordToggle.innerHTML = '<i style="font-size:24px" class="fa">&#xf070;</i>';
      } else {
        passwordInput.type = "password";
        passwordToggle.innerHTML = '<i style="font-size:24px" class="fa">&#xf06e;</i>';
      }
    }
  </script>
</body>
</html><!-- Add this script after the HTML content -->
<script>
  // Function to hide the error message after a specified delay
  function hideErrorMessage() {
    var errorMessage = document.querySelector('.errorMessage');
    if (errorMessage) {
      setTimeout(function() {
        errorMessage.style.display = 'none';
      }, 3000); // 3000 milliseconds = 3 seconds
    }
  }

  // Call the hideErrorMessage function when the page finishes loading
  window.addEventListener('load', hideErrorMessage);
</script>
